<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouProjectsChart license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

require_once 'modules/Webforms/model/WebformsModel.php';
require_once 'include/Webservices/DescribeObject.php';

class ITS4YouProjectsChart
{

    public static $db;
    public $log;

    // Cache to speed up describe information store
    protected static $moduleDescribeCache = [];

    function __construct()
    {
        global $log, $currentModule;

        self::init();
        $this->log = $log;
    }

    private static function init()
    {
        global $adb;
        self::setDb($adb);
    }

    /**
     * @return PearDatabase
     */
    public static function getDb()
    {
        return self::$db;
    }

    /**
     * @param PearDatabase $db
     */
    public static function setDb($db)
    {
        self::$db = $db;
    }

    function vtlib_handler($moduleName, $eventType)
    {
        require_once('include/utils/utils.php');
        require_once('vtlib/Vtiger/Module.php');
        self::init();

        switch ($eventType) {
            case 'module.postinstall':
            case 'module.enabled':
                $this->enableProjectsChart();
                break;
            case 'module.preuninstall':
            case 'module.disabled':
                $this->disableProjectsChart();
                break;
            case 'module.postupdate':
            case 'module.preupdate':
                break;
        }
    }

    private static function getLinkLabel()
    {
        return 'Projects Chart';
    }

    private static function getModuleName()
    {
        return get_called_class();
    }

    private static function getUrl()
    {
        return sprintf(
            'index.php?module=%s&view=List&mode=showChart',
            self::getModuleName()
        );
    }

    private static function getProjectModuleName()
    {
        return 'Project';
    }

    private static function getHeaderLinkLabel()
    {
        return 'Projects Chart Js';
    }

    private static function getHeaderJsUrl()
    {
        return sprintf(
            'layouts/%s/modules/%s/resources/%s_HS.js',
            (string)Vtiger_Viewer::getDefaultLayoutName(),
            self::getModuleName(),
            self::getModuleName()
        );
    }

    public static function stringToColorCode($str)
    {
        $code = rand(0, 9) . dechex(crc32($str)) . rand(0, 9);
        $code = '#' . substr($code, 0, 6);

        return $code;
    }

    function enableProjectsChart()
    {
        $moduleModel = Vtiger_Module_Model::getInstance(self::getProjectModuleName());
        $moduleTabId = $moduleModel->getId();

        Vtiger_Link::addLink($moduleTabId, 'HEADERSCRIPT', self::getHeaderLinkLabel(), self::getHeaderJsUrl(), '', '0');
//        Settings_MenuEditor_Module_Model::addModuleToApp('ITS4YouProjectsChart', 'PROJECT');
    }

    function disableProjectsChart()
    {
        $moduleModel = Vtiger_Module_Model::getInstance(self::getProjectModuleName());
        $moduleTabId = $moduleModel->getId();

        Vtiger_Link::deleteLink($moduleTabId, 'HEADERSCRIPT', self::getHeaderLinkLabel());
    }

    public function addCustomLinks()
    {
    }

    public function deleteCustomLinks()
    {
    }
}
