<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskLogisticssendlocation extends \Workflow\Task
{
    /**
     * @var \Workflow\Preset\SimpleConfig
     */
    private $_SC = null;

    protected $_envSettings = array("record_id", "address_id");

    public function init()
    {
        $this->_SC = $this->addPreset("SimpleConfig", "details", array(
            'templatename' => 'mainconfig',
        ));

        if($this->isConfiguration()) {
            $this->_SC->setColumnCount(1);

            $this->_SC->addFields('providerid', 'Logistics Provider', 'provider', array(
                'provider' => 'flexxlogistics'
            ));

            if($this->_SC->has('providerid')) {
                $this->_SC->addFields('recordid', 'Record ID to connect Location ID', 'template');
                $this->_SC->addFields('title', 'Titel', 'template');
                $this->_SC->addFields('type', 'Typ', 'select', array(
                    'options' => array(
                        'Warehouse' => 'Lager',
                        'Accommodation' => 'Unterkunft',
                    )
                ));

                $this->_SC->addHeadline('Addressdaten');
                $this->_SC->addFields('company', 'Unternehmen', 'template');
                $this->_SC->addFields('address', 'Adresse', 'template');
                $this->_SC->addFields('postalcode', 'Postleitzahl', 'template');
                $this->_SC->addFields('city', 'Stadt', 'template')
                ;
                $this->_SC->addFields('country', 'Land ISO Code, 3 stellig', 'template');


            }
        }

    }

    public function handleTask(&$context) {
        /* Insert here source code to execute the task */
        /**
         * @var $provider \Workflow\Plugins\ConnectionProvider\FlexxLogistics
         */
        $provider = \Workflow\ConnectionProvider::getConnection($this->_SC->get('providerid'));

        $storeContextId = $this->_SC->get('recordid');
        if(empty($storeContextId) || $storeContextId === -1) {
            $storeContextId = $context->getId();
        }

        if($context->getId() != $storeContextId) {
            $storeContext = \Workflow\VTEntity::getForId($storeContextId);
        } else {
            $storeContext = $context;
        }

        $id = $storeContext->getEntityData('locationid');
        if($id === -1) $id = null;
        $addressId = $storeContext->getEntityData('addressid');

        $vehicle = array(
            'company' => $this->_SC->get('company'),
            'address' => $this->_SC->get('address'),
            'postalcode' => $this->_SC->get('postalcode'),
            'city' => $this->_SC->get('city'),
            'country' => $this->_SC->get('country'),
        );

        if($addressId === -1 || empty($addressId)) {
            $address = $provider->sendRequest('addresses', $vehicle);
            $addressId = $address->id;
        } else {
            $response = $provider->sendRequest('addresses/' . $addressId, $vehicle, 'PUT');
        }

        $location = array(
            'address' => '/api/addresses/' . $addressId,
            'title' => $this->_SC->get('title'),
            'type' => $this->_SC->get('type'),
        );

        if(empty($id)) {
            $response = $provider->sendRequest('locations', $location);
        } else {
            $response = $provider->sendRequest('locations/' . $id, $location, 'PUT');
        }

        $storeContext->addEntityData('locationid', $response->id);
        $storeContext->addEntityData('addressid', $addressId);

        $context->setEnvironment('record_id', $response->id, $this);
        $context->setEnvironment('address_id', $addressId, $this);

        return "yes";
    }

    public function beforeGetTaskform($viewer) {
        /* Insert here source code to create custom configurations pages */
    }
    public function beforeSave(&$values) {
        /* Insert here source code to modify the values the user submit on configuration */
    }
}
