<?php
require_once(realpath(dirname(__FILE__).'/../autoload_wf.php'));

class WfTaskLogisticssenddelivery extends \Workflow\Task
{
    /**
     * @var \Workflow\Preset\SimpleConfig
     */
    private $_SC = null;

    protected $_envSettings = array("record_id", "source_address_id", "dest_addressid");

    public function init()
    {
        $this->_SC = $this->addPreset("SimpleConfig", "details", array(
            'templatename' => 'mainconfig',
        ));

        if($this->isConfiguration()) {
            $this->_SC->setColumnCount(1);

            $this->_SC->addFields('providerid', 'Logistics Provider', 'provider', array(
                'provider' => 'flexxlogistics'
            ));

            if($this->_SC->has('providerid')) {
                $this->_SC->addFields('recordid', 'Delivery ID to update', 'template');

                $this->_SC->addHeadline('Daten zur Lieferung');
                $this->_SC->addFields('orderId', 'Bestellnummer', 'template');
                $this->_SC->addFields('ordertext', 'Titel der Bestellung', 'template');
                $this->_SC->addFields('orderDate', 'Bestelldatum', 'template');

                $this->_SC->addFields('deliveryDuration', 'Dauer der Lieferung in Minuten', 'template');
                $this->_SC->addFields('customer', 'Kundenname', 'template');

                $this->_SC->addFields('notice', 'Notiz', 'textarea');
                $this->_SC->addFields('extraText', 'Extra Text', 'template');

                $this->_SC->addFields('inventoryId', 'Lade Lieferdetails aus diesem Eintrag', 'template', array('default' => '$crmid'));

                $this->_SC->addHeadline('Versandadresse');
                $this->_SC->addFields('source_addressid', 'Address ID', 'template');
                $this->_SC->addFields('source_company', 'Unternehmen', 'template');
                $this->_SC->addFields('source_address', 'Adresse', 'template');
                $this->_SC->addFields('source_postalcode', 'Postleitzahl', 'template');
                $this->_SC->addFields('source_city', 'Stadt', 'template');
                $this->_SC->addFields('source_country', 'Land ISO Code, 3 stellig', 'template');

                $this->_SC->addHeadline('Zieladresse');
                $this->_SC->addFields('dest_addressid', 'Address ID', 'template');
                $this->_SC->addFields('dest_company', 'Unternehmen', 'template');
                $this->_SC->addFields('dest_address', 'Adresse', 'template');
                $this->_SC->addFields('dest_postalcode', 'Postleitzahl', 'template');
                $this->_SC->addFields('dest_city', 'Stadt', 'template');
                $this->_SC->addFields('dest_country', 'Land ISO Code, 3 stellig', 'template');

                $this->_SC->addHeadline('Produktdaten');
                $this->_SC->addFields('articleNumber', 'Artikelnummer', 'fields', array('modulename' => 'Products', 'single' => true));
                $this->_SC->addFields('articleText', 'Artikelname', 'fields', array('modulename' => 'Products', 'single' => true));
                $this->_SC->addFields('nonDelivery', 'Checkbox "nicht liefern"', 'fields', array('modulename' => 'Products', 'single' => true));

                $this->_SC->addFields('payloadWeight', 'Gewicht pro Stück (kg)', 'fields', array('modulename' => 'Products', 'single' => true));
                $this->_SC->addFields('sizeWidth', 'Breite (m)', 'template');
                $this->_SC->addFields('sizeHeight', 'Höhe (m)', 'template');
                $this->_SC->addFields('sizeLength', 'Länge (m)', 'template');
            }
        }

    }

    public function handleTask(&$context) {
        /* Insert here source code to execute the task */
        /**
         * @var $provider \Workflow\Plugins\ConnectionProvider\FlexxLogistics
         */
        $provider = \Workflow\ConnectionProvider::getConnection($this->_SC->get('providerid'));

        $id = $this->_SC->get('recordid');
        if($id === -1) $id = null;

        $srcAddressId = $this->_SC->get('source_addressid');
        if($srcAddressId === -1 || empty($srcAddressId)) {
            $vehicle = array(
                'company' => $this->_SC->get('source_company'),
                'address' => $this->_SC->get('source_address'),
                'postalcode' => $this->_SC->get('source_postalcode'),
                'city' => $this->_SC->get('source_city'),
                'country' => $this->_SC->get('source_country'),
            );

            $address = $provider->sendRequest('addresses', $vehicle);
            $srcAddressId = $address->id;

            $context->setEnvironment('source_address_id', $srcAddressId, $this);
        }

        $destAddressId = $this->_SC->get('dest_addressid');
        if($destAddressId === -1 || empty($destAddressId)) {
            $vehicle = array(
                'company' => $this->_SC->get('dest_company'),
                'address' => $this->_SC->get('dest_address'),
                'postalcode' => $this->_SC->get('dest_postalcode'),
                'city' => $this->_SC->get('dest_city'),
                'country' => $this->_SC->get('dest_country'),
            );

            $address = $provider->sendRequest('addresses', $vehicle);
            $destAddressId = $address->id;

            $context->setEnvironment('dest_address_id', $destAddressId, $this);
        }

        $delivery = array(
            'orderId' => $this->_SC->get('orderId'),
            'ordertext' => $this->_SC->get('ordertext'),
            'deliveryDuration' => floatval($this->_SC->get('deliveryDuration')),
            'payloadWeight' => '',
            'notice' => $this->_SC->get('notice'),
            'destAddress' => '/api/addresses/'.$destAddressId,
            'extraText' => $this->_SC->get('extraText'),
            'customer' => $this->_SC->get('customer'),
            'orderDate' => $this->_SC->get('orderDate'),
            'sourceAddress' => '/api/addresses/'.$srcAddressId ,
            'payloads' => array()
        );

        $inventoryId = $this->_SC->get('inventoryId');

        if(!empty($inventoryId)) {
            $inventorySource = \Workflow\VTEntity::getForId($inventoryId);

            $inventory = $inventorySource->exportInventory();

            foreach($inventory['listitems'] as $product) {
                $productObj = \Workflow\VTEntity::getForId($product['productid'], 'Products');

                $value = $productObj->get($this->_SC->get('nonDelivery'));
                if(!empty($value)) {
                    continue;
                }

                $articleNumberFields = $this->_SC->get('articleNumber');
                $articleTextFields = $this->_SC->get('articleText');
                $payloadWeightFields = $this->_SC->get('payloadWeight');

                $payload = array(
                    'articleNumber' => $productObj->get($articleNumberFields[0]),
                    'articleText' => $productObj->get($articleTextFields[0]),
                    'payloadWeight' => '' . $product['quantity'] * floatval($productObj->get($payloadWeightFields[0])),
                    'payloadCount' => 1,
                    'sizeWidth' => $this->_SC->get('sizeWidth'),
                    'sizeHeight' => $this->_SC->get('sizeHeight'),
                    'sizeLength' => $this->_SC->get('sizeLength'),
                );

                $response = $provider->sendRequest('payloads', $payload);

                $delivery['payloads'][] = '/api/payloads/'. $response->id;
            }

        }

        if(empty($id)) {
            $response = $provider->sendRequest('deliveries', $delivery);
        } else {
            $response = $provider->sendRequest('deliveries/' . $id, $delivery, 'PUT');
        }
        var_dump($response);

        $context->setEnvironment('record_id', $response->id, $this);

        return "yes";
    }

    public function beforeGetTaskform($viewer) {
        /* Insert here source code to create custom configurations pages */
    }
    public function beforeSave(&$values) {
        /* Insert here source code to modify the values the user submit on configuration */
    }
}
