<?php

/**
 * Created by PhpStorm.
 * User: Stefan
 * Date: 25.05.2016
 * Time: 08:29
 */
namespace Workflow\CommunicationProvider;

use Workflow\VtUtils;

class Twilio extends \Workflow\CommunicationPlugin
{
    protected $usernameLabel = 'Account SID';
    protected $passwordLabel = 'Auth Token';

    protected $name = 'Twilio';

    protected $supported = array(
        'sms' => true
    );

    public function SMS($data) {
        $sid = $this->get('username');
        $token = $this->get('password');

        if(empty($data['from'])) {
            $data['from'] = $this->get('default_from');
        }

        if(substr($data['to'], 0, 2) == '00') {
            $data['to'] = '+'.ltrim($data['to'], '0');
        }

        if(substr($data['from'], 0, 2) == '00') {
            $data['from'] = '+'.ltrim($data['from'], '0');
        }

        $parameter = array(
            'To' => ($data['to']),
            'From' => ($data['from']),
            'Body' => $data['content']
        );

        $response = VtUtils::getContentFromUrl('https://api.twilio.com/2010-04-01/Accounts/'.$sid.'/Messages.json', $parameter, 'post', array('successcode' => array(200, 201), 'auth' => array('user' => $sid, 'password' => $token)));
    }

    public function test() {
        $sid = $this->get('username');
        $token = $this->get('password');

        $response = VtUtils::getContentFromUrl('https://api.twilio.com/2010-04-01/Accounts/'.$sid.'.json', array(), 'get', array('auth' => array('user' => $sid, 'password' => $token)));
        if(empty($response)) {
            throw new \Exception('Login credentials could not be verified. Please check if you are using Account SID and no single API Key');
        }

    }

    public function getConfigFields()
    {
        $return = parent::getConfigFields(); // TODO: Change the autogenerated stub
        $return['default_from'] = array(
            'label' => 'Default Sender',
            'type' => 'text',
        );

        return $return;
    }

    // Add Default Sender
    public function getDataFields($method) {
        $return = parent::getDataFields($method);
        $return['from']['placeholder'] = $this->get('default_from');
        return $return;
    }

}

\Workflow\CommunicationPlugin::register('twilio', '\\Workflow\\CommunicationProvider\\Twilio');