<?php

/**
* VGS Dynamic Blocks
 *
 * @package        VGS Dynamic Blocks
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2014 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */
class VGSDynamicBlocks {
	
	function vtlib_handler($moduleName, $eventType) {
		$adb = PearDatabase::getInstance();
		
		
		if ($eventType == 'module.postinstall') {
			$this->AddSettingsLinks('VGSDynamicBlocks');
            $this->addLinks('VGSDynamicBlocks');
		}
		else if ($eventType == 'module.disabled') {
            $this->AddSettingsLinks('VGSDynamicBlocks', false);
            require_once('vtlib/Vtiger/Link.php');
			$tabid = getTabId("VGSDynamicBlocks");
			Vtiger_Link::deleteAll($tabid);
		}
		else if ($eventType == 'module.enabled') {
            $this->AddSettingsLinks('VGSDynamicBlocks');
            $this->addLinks('VGSDynamicBlocks');
		}
		else if ($eventType == 'module.preuninstall') {
			$adb->pquery('DELETE FROM vtiger_settings_field WHERE  name= ?', array('VGSDynamicBlocks'));
			require_once('vtlib/Vtiger/Link.php');
			$tabid = getTabId("VGSDynamicBlocks");
			Vtiger_Link::deleteAll($tabid);
		}
		else if ($eventType == 'module.postupdate') {
			$this->AddSettingsLinks('VGSDynamicBlocks');
			$this->addLinks('VGSDynamicBlocks');
		}
	}
	
	function AddSettingsLinks($moduleName, $setToActive = true){
		$adb = PearDatabase::getInstance();
		$otherSettingsBlock = $adb->pquery('SELECT * FROM vtiger_settings_blocks WHERE label=?', array('LBL_OTHER_SETTINGS'));
		$otherSettingsBlockCount = $adb->num_rows($otherSettingsBlock);
		
		if ($otherSettingsBlockCount > 0) {
			$blockid = $adb->query_result($otherSettingsBlock, 0, 'blockid');
			$sequenceResult = $adb->pquery("SELECT max(sequence) as sequence FROM vtiger_settings_blocks WHERE blockid=?", array($blockid));
			if ($adb->num_rows($sequenceResult)) {
				$sequence = $adb->query_result($sequenceResult, 0, 'sequence');
			}
		}
		
		$result = $adb->pquery('SELECT * FROM vtiger_settings_field WHERE name=?',[$moduleName]);
		
		if($result && $adb->num_rows($result) == 0){
			$fieldid = $adb->getUniqueID('vtiger_settings_field');
			$adb->pquery("INSERT INTO vtiger_settings_field(fieldid, blockid, name, iconpath, description, linkto, sequence, active) 
                        VALUES(?,?,?,?,?,?,?,?)", array($fieldid, $blockid, $moduleName, '', $moduleName . ' Configuration', 'index.php?parent=Settings&module=VGSDynamicBlocks&view=SettingList', $sequence++, 0));
		}
		
		if($setToActive){
			$adb->pquery("UPDATE vtiger_settings_field SET active=0 WHERE vtiger_settings_field.name=?", array($moduleName));
		}
		else{
			$adb->pquery("UPDATE vtiger_settings_field SET active=1 WHERE vtiger_settings_field.name=?", array($moduleName));
		}
		
	}

    function addLinks($moduleName){
        $tabid = getTabId($moduleName);
        include('vtigerversion.php');
        $version = explode('.', $vtiger_current_version)[0];

        if ($version > 6) {
                Vtiger_Link::addLink(getTabid($moduleName), 'HEADERSCRIPT', $moduleName, 'layouts/v7/modules/VGSDynamicBlocks/resources/VGSDynamicBlocks.js', '', 0, '');
            } else {
                Vtiger_Link::addLink(getTabid($moduleName), 'HEADERSCRIPT', $moduleName, 'layouts/vlayout/modules/VGSDynamicBlocks/resources/VGSDynamicBlocks.js', '', 0, '');
            }
    }
	
}
