<?php
/*+**********************************************************************************
 The content of this file is subject to the ITS4YouMention license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

class ITS4YouMention
{
    public $moduleInstance;
    public $moduleName = 'ITS4YouMention';
    public $moduleLabel = 'Mention';
    public $db;
    public $log;
    public $layout;

    function __construct()
    {
        global $log, $currentModule;

        $this->db = PearDatabase::getInstance();
        $this->log = $log;
    }

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type
     * @throws Exception
     */
    function vtlib_handler($moduleName, $eventType)
    {
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'vtlib/Vtiger/Event.php';

        switch ($eventType) {
            case 'module.postupdate':
            case 'module.enabled':
            case 'module.postinstall':
                $this->addCustomLinks();
                break;
            case 'module.preupdate':
            case 'module.preuninstall':
            case 'module.disabled':
                $this->deleteCustomLinks();
                break;
        }
    }

    /**
     * @throws Exception
     */
    public function addCustomLinks()
    {
        $this->updateCustomLinks();
	    $this->updateEventHandler();
    }

    public function deleteCustomLinks()
    {
	    $this->updateCustomLinks(false);
		$this->updateEventHandler(false);
    }

	/**
	 * [module, type, label, url, icon, sequence, handlerInfo]
	 * @return array
	 */
	public $registerCustomLinks = array(
		['ITS4YouMention', 'HEADERSCRIPT', 'ITS4YouMention_HS', 'layouts/$LAYOUT$/modules/ITS4YouMention/resources/ITS4YouMentions_HS.js']
	);

	/**
	 * @param bool $register
	 */
	public function updateCustomLinks($register = true)
	{
		foreach ($this->registerCustomLinks as $customLink) {
			list($moduleName, $type, $label, $url, $icon, $sequence, $handler) = array_pad($customLink, 7, null);
			$module = Vtiger_Module::getInstance($moduleName);
			$url = str_replace('$LAYOUT$', Vtiger_Viewer::getDefaultLayoutName(), $url);

			if ($module) {
				$module->deleteLink($type, $label);

				if ($register) {
					$module->addLink($type, $label, $url, $icon, $sequence, $handler);
				}
			}
		}
	}

	/**
	 * @var array
	 * [events, file, class, condition, dependOn, modules]
	 */
	public $registerEventHandler = [
		['vtiger.entity.aftersave', 'modules/ITS4YouMention/ITS4YouMentionHandler.php', 'ITS4YouMentionHandler', '', '', 'ModComments'],
	];

	/**
	 * @param bool $register
	 */
	public function updateEventHandler($register = true)
	{
		$eventsManager = new VTEventsManager($this->db);

		foreach ($this->registerEventHandler as $data) {
			list($events, $fileName, $className, $condition, $dependOn, $modules) = $data;

			$eventsManager->unregisterHandler($className);

			if ($register) {
				$dependOn = !empty($dependOn) ? $dependOn : '[]';

				foreach ((array)$events as $event) {
					$eventsManager->registerHandler($event, $fileName, $className, $condition, $dependOn);

					foreach ((array)$modules as $module) {
						$eventsManager->setModuleForHandler($module, $className);
					}
				}
			}
		}
	}
}