<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouMention license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouMention_Record_Model extends Vtiger_Record_Model
{
    protected $parent;
    protected $comment;
    protected $mentioned = array();

    public function setParent($value)
    {
        $this->parent = $value;
    }

    public function setComment($value)
    {
        $this->comment = $value;
    }

    /**
     * @return array
     */
    public function getMentionedUsers()
    {
        $parentModule = $this->getParentModuleName();
        /** @var ITS4YouMention_Module_Model $moduleModel */
        $moduleModel = $this->getModule();
        $userRecords = $moduleModel->getAccessibleUsers($parentModule);
        $comment = $this->comment;
        $mentionedUsers = array();

        foreach ($userRecords as $userId => $userRecord) {
            if(false !== strpos($comment, '@'.$userRecord->get('user_name'))) {
                $mentionedUsers[$userId] = $userRecord;
            }
        }

        $groupRecords = $moduleModel->getAccessibleGroups($parentModule);
        /** @var Settings_Groups_Record_Model $groupRecord */

        foreach ($groupRecords as $groupId => $groupRecord) {
            if (false !== strpos($comment, '@' . $moduleModel->getGroupName($groupRecord))) {

                foreach ($groupRecord->getUsersList() as $userId => $userRecord) {
                    $mentionedUsers[$userId] = $userRecord;
                }
            }
        }

        return $mentionedUsers;
    }

    /**
     * @return string
     */
    public function getParentModuleName()
    {
        return $this->getParentRecord()->getModuleName();
    }

    /**
     * @return object
     */
    public function getParentRecord()
    {
        return Vtiger_Record_Model::getInstanceById($this->parent);
    }

    public function save()
    {
        return false;
    }

    public function sendEmail()
    {
        global $log;
        $log->info("ITS4YouMention:: Send->Started");

        $parentRecord = $this->getParentRecord();
        $emailInfo = $this->getEmailInfo();

        foreach ($emailInfo as $userId => $userEmail) {
            /** @var $email Emails_Record_Model */
            $email = Vtiger_Record_Model::getCleanInstance('Emails');
            $email->set('subject', $this->getEmailSubject());
            $email->set('description', $this->getEmailMessage($userId));
            $email->set('toemailinfo', [
                $userId => [$userEmail],
            ]);
            $email->set('saved_toid', $userEmail);
            $email->set('parent_id', $parentRecord->getId());
            $email->set('email_flag', 'SENT');
            $email->set('assigned_user_id', $parentRecord->get('assigned_user_id'));
            $email->save();
            $email->send();
        }

        $log->info("ITS4YouMention:: Send->Ended");
    }

    public function getEmailSubject()
    {
        $userRecord = Users_Record_Model::getCurrentUserModel();
        $parentRecord = $this->getParentRecord();

        return $userRecord->getName() . ' ' . vtranslate('mentioned you on', $this->getModuleName()) . ' ' . $parentRecord->getName();
    }

    public function getCommentMessage()
    {
        /**
         * @var ITS4YouMention_Module_Model $moduleModel
         * @var Settings_Groups_Record_Model $groupRecord
         */
        $parentModule = $this->getParentModuleName();
        $moduleModel = $this->getModule();
        $comment = $this->comment;
        $users = $this->getMentionedUsers();

        foreach ($users as $user) {
            $comment = str_replace(sprintf('@%s', $user->get('user_name')), sprintf('<b>@%s</b>', $user->getName()), $comment);
        }

        $groups = $moduleModel->getAccessibleGroups($parentModule);

        foreach ($groups as $groupId => $group) {
            $comment = str_replace(sprintf('@%s', $moduleModel->getGroupName($group)), sprintf('<b>@%s</b>', $group->getName()), $comment);
        }

        return $comment;
    }

    /**
     * @param int $userId
     * @return string
     */
    public function getEmailMessage($userId = 0)
    {
        $currentUser = Users_Record_Model::getCurrentUserModel();
        /** @var Vtiger_Record_Model $parentRecord */
        $parentRecord = $this->getParentRecord();
        $moduleName = $this->getModuleName();
        $mentionedMessage = vtranslate('LBL_MENTIONED_YOU', $moduleName);
        $clickMessage = vtranslate('LBL_CLICK_HERE', $moduleName);

        if ($userId) {
            $userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');

            if ($userRecordModel) {
                $language = $userRecordModel->get('language');
                $mentionedMessage = Vtiger_Language_Handler::getLanguageTranslatedString($language, 'LBL_MENTIONED_YOU', $moduleName);
                $clickMessage = Vtiger_Language_Handler::getLanguageTranslatedString($language, 'LBL_CLICK_HERE', $moduleName);
            }
        }

        if(empty($mentionedMessage)) {
            $mentionedMessage = 'mentioned you in a comment.';
        }

        if(empty($clickMessage)) {
            $clickMessage = 'Please click here to view the record.';
        }

        $viewer = new Vtiger_Viewer();
        $viewer->assign('RECORD_TITLE', $parentRecord->getName());
        $viewer->assign('RECORD_MESSAGE', $this->getCommentMessage());
        $viewer->assign('RECORD_URL', ITS4YouMention_Module_Model::getSiteUrl() . $parentRecord->getDetailViewUrl());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('RECORD_MODEL', $this);
        $viewer->assign('COMPANY', Vtiger_CompanyDetails_Model::getInstanceById());
        $viewer->assign('COMPANY_LOGO', $this->getCompanyImage());
        $viewer->assign('CURRENT_USER', $currentUser);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('MESSAGE_MENTIONED_YOU', $mentionedMessage);
        $viewer->assign('MESSAGE_CLICK_HERE', $clickMessage);

        return $viewer->view('Email.tpl', $this->getModuleName(), true);
    }

    public function getCompanyImage() {
        $company = Vtiger_CompanyDetails_Model::getInstanceById();
        $logo = $company->getLogo();

        return ($logo && is_file($logo->get('imagepath'))) ? 'data:image/png;base64,'.base64_encode(file_get_contents($logo->get('imagepath'))) : '';
    }

    public function getEmailInfo()
    {
        $users = $this->getMentionedUsers();
        $emails = array();

        foreach ($users as $user) {
            $emails[$user->getId()] = $user->get('email1');
        }

        return $emails;
    }
}